/* eslint-disable indent */
/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于巡检界面
 *
 * 修改:
 *      类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.04.07
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported  mc_send_screen_param_inspection */
/* exported  mc_close_auto_bright */
/* exported  mc_deal_screen_data */
/* exported  mc_get_all_box_name */
/* exported  mc_deal_gaumt */
/* exported  mc_get_gamma */
/* exported  mc_filter_order */
/* exported  mc_if_set_time */
/* exported  mc_send_hw_soft */
/* exported  mc_if_open_time */
/* exported  mc_analysic_screen_data */
/* exported  mc_deal_recv_card_name */


/* global $ */
/* global mc_sdk_param */
// 设置箱体跟偏移的索引标识
var ui_box_idx = 1;
var ui_offset_id = 1;

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    大屏参数巡检 只允许发一张发送卡下的大屏
 * 参数:
 *    @param {Promise<Array>} arr_order     指令[(-1:-1;-1:-1:-1),(-1:-1;-1:-1:-1),...]
 *    @param {Promise<Object>} obj_params_all     所有界面参数(时间/开关/所有下发信息 除了偏移/接收卡名称)
 *    @param {Promise<String>} str_type     工作模式(软件/硬件/关闭)
 *    @param {Promise<String>} obj_screen_param     箱体参数(偏移/接收卡名称/箱体名称)
 *    @param {Promise<Array>} arr_recv_c_name     接收卡名称 [1,2,3,4,...] 按发送卡顺序存取
 *    @param {Promise<Object>} obj_s_h_outport     主控/分控输出端口数据
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.9.07
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_send_screen_param_inspection(arr_order, obj_params_all, str_type, obj_screen_param, arr_recv_c_name, obj_s_h_outport, obj_local_inspection, fun_callback) {
    // 工作模式
    var str_work_mode = str_type;

    // 获取发送卡名称/hub卡名称
    mc_get_send_name(function (arr) {
        // 获取失败则返回
        if ("MC_LANG_INSPECTION_NO_SEND_NAME" === arr) {
            fun_callback(arr);
            return;
        }

        // 处理各参数数据 生成表达式
        var obj_all_params = mc_deal_params(arr_order, obj_params_all, str_work_mode, obj_screen_param, arr, arr_recv_c_name, obj_s_h_outport, obj_local_inspection);

        // 发送主或备
        var str_send_back_path = obj_local_inspection.backup ? "1" : "0";

        // 最后 下发数据
        mc_send_req(obj_all_params, str_work_mode, str_send_back_path, function (error) {
            fun_callback(error);
        });
        return;
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    大屏参数巡检
 * 参数:
 *    @param {Promise<Array>} obj_data    所有下发参数指令 以key为索引依次下发数据
 *    @param {Promise<string>} str_work_mode    工作模式 0:关闭 1:软件 2:硬件
 *    @param {Promise<string>} str_send_back_path    备份口发送模式
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.9.07
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_send_req(obj_data, str_work_mode, str_send_back_path, fun_callback) {
    // 发送卡索引
    var str_sendcard_id = "";
    // 发送卡名称
    var str_sendcard_name = "";
    // 接收卡名称
    var str_recvcard_name = "";

    // 下发提示
    var str_error = "";

    send_req();

    function send_req() {
        // 赋值

        str_sendcard_id = "-1";
        str_sendcard_name = obj_data.send_name;
        str_recvcard_name = obj_data.rece_name;


        var obj_req = new mc_sdk_param();

        obj_req.set_param_clear();
        obj_req.set_cmd("SET_PARAM");
        obj_req.set_func("HW_PARAM_AUTO_SEND");
        obj_req.set_param_value(str_sendcard_id, "");

        obj_req.set_attr_val(str_sendcard_id, "SENDCARD_NAME", str_sendcard_name);
        obj_req.set_attr_val(str_sendcard_id, "RECVCARD_NAME", str_recvcard_name);
        obj_req.set_attr_val(str_sendcard_id, "BACKUP_MODE", str_send_back_path);

        for (var key in obj_data) {
            if ("rece_name" === key || "send_name" === key) {
                continue;
            }


            // 工作模式为0时不设置索引参数
            if ("0" === str_work_mode) {
                //若参数为空意味着不发
                if (!obj_data[key][0]) {
                    continue;
                }
                obj_req.set_attr_val(str_sendcard_id, key, obj_data[key][0]);
            } else {
                // 若索引或数据为空意味着不发
                if (0 === obj_data[key][1].length || 0 === obj_data[key][2].length || !obj_data[key][2][0]) {
                    continue;
                }

                obj_req.set_attr_val(str_sendcard_id, key, obj_data[key][0]);

                // 设置索引 参数
                var arr_idx = obj_data[key][1];
                var arr_idx_val = obj_data[key][2];
                var ui_length = arr_idx.length;

                for (var id = 0; id < ui_length; id++) {
                    obj_req.set_attr_val(str_sendcard_id, arr_idx[id], arr_idx_val[id]);
                }
            }
        }
        obj_req.set_attr_val(str_sendcard_id, "WORK_MODE", str_work_mode);


        $.post("/access_shell", obj_req.get_json(), function (result, status) {
            var obk_box_offset_res = new mc_sdk_param();

            obk_box_offset_res.set_json(result);
            var error = obk_box_offset_res.get_param_value("ERROR_CODE");

            if ("0x00000000" === error || !error) {
                str_error = "MC_LANG_SNED_SUCCESS";
            } else {
                str_error = "ErrorCode : " + error;
            }

            fun_callback(str_error);
            return;
        });
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取所有指令 下发所有指令箱体
 * 参数:
 *    @param {Promise<object>} obj_data   箱体数据
 * 返回：
 *    @returns  {Promise<Array>} arr_data 处理后的矫正数据

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.04.08
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_filter_order(obj_data) {
    // 下发的指令集合
    var arr_data = [];

    // eslint-disable-next-line guard-for-in
    for (var key in obj_data) {
        arr_data.push(key);
    }

    return arr_data;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理所有参数数据 生成表达式
 * 参数:
 *    @param {Promise<Array>} arr_select_order   所有的硬件指令
 *    @param {Promise<object>} obj_param_all   所有参数数据(不包括箱体数据->偏移/箱体参数/接收卡名称 需从 obj_screen_param 参数箱体数据获取)
 *    @param {Promise<String>} str_type   工作模式 1->软件 2->硬件 0->关闭 3 ->软硬件
 *    @param {Promise<object>} obj_screen_param   箱体参数 接收卡名称/偏移/箱体名称
 *    @param {Promise<Array>} arr_send_name   发送卡名称
 *    @param {Promise<Array>} arr_recv_c_name   接收卡名称
 *    @param {Promise<Object>} obj_s_h_outport     主控/分控输出端口数据
 *    @param {Promise<Object>} obj_local_inspection     界面参数信息

 * 返回：
 *    @return {Promise<object>} obj_data 处理后的表达
 *  备注 : 获取每一个下发的参数
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.04.07
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_deal_params(arr_select_order, obj_param_all, str_type, obj_screen_param, arr_send_name, arr_recv_c_name, obj_s_h_outport, obj_local_inspection) {
    // 表达式 mode 模式
    var str_mode = "";
    // 表达式第二个参数 时间 PARAM
    var str_time_data = "";

    var arr_all_params = ["SENDCARD_OUTPORT", "HUBCARD_OUTPORT", "OFFSET", "BRIGHT", "GAMMA", "GAMUT", "BOX"];
    // 界面事件参数 obj
    var obj_time_data = obj_local_inspection.time;
    // 是否开启定时
    var arr_time_set = obj_local_inspection.check;
    // 最终下发数据
    var obj_data = {};

    // 获取当前发送卡数量
    var ui_send_card_cnt = arr_send_name.length;
    // 当前发送卡位置索引
    var str_curr_s_id = arr_select_order[0].split(":")[0];

    for (var id_s = 0; id_s < ui_send_card_cnt; id_s++) {
        // 存放所有表达式 [key1,key2] key1:表达式 key2:索引
        obj_data = {
            SENDCARD_OUTPORT: ["", [], []],
            HUBCARD_OUTPORT: ["", [], []],
            OFFSET: ["", [], []],
            BRIGHT: ["", [], []],
            GAMMA: ["", [], []],
            GAMUT: ["", [], []],
            BOX: ["", [], []],
            rece_name: arr_recv_c_name[id_s],
            send_name: arr_send_name[id_s]
        };

        if ("0" === str_type) {
            continue;
        }

        for (var idx = 0; 7 > idx; idx++) {
            // 暂时不发主控
            if (0 === idx) {
                continue;
            }

            // 名称索引
            var str_param = arr_all_params[idx];

            // 表达式第一个参数MODE
            str_mode = mc_deal_mode(idx, obj_local_inspection, str_type, str_param);
            // 开启就加时间 不开启直接过 arr_time_set[idx] || "2" === str_mode
            // if ("0" === str_mode) {
            //     str_time_data = "0";
            // } else {
            //     if (!arr_time_set[idx]) {
            //         str_time_data = "0";
            //     } else {
            //         str_time_data = mc_set_time(obj_time_data, str_param);
            //     }
            // }


            if (!arr_time_set[idx]) {
                continue;
            }
            str_time_data = mc_set_time(obj_time_data, str_param);

            switch (str_param) {
                case "SENDCARD_OUTPORT":
                    // 主控图像
                    var arr_send_port = mc_deal_s_h_port(str_mode, str_time_data, obj_s_h_outport, "s_outport");

                    obj_data.SENDCARD_OUTPORT[0] = arr_send_port[0];
                    obj_data.SENDCARD_OUTPORT[1] = arr_send_port[1];
                    obj_data.SENDCARD_OUTPORT[2] = arr_send_port[2];
                    break;
                case "HUBCARD_OUTPORT":
                    // 分控图像
                    var arr_hub_port = mc_deal_s_h_port(str_mode, str_time_data, obj_s_h_outport, "h_outport");

                    obj_data.HUBCARD_OUTPORT[0] = arr_hub_port[0];
                    obj_data.HUBCARD_OUTPORT[1] = arr_hub_port[1];
                    obj_data.HUBCARD_OUTPORT[2] = arr_hub_port[2];
                    break;
                case "OFFSET":
                    // 处理当前偏移 "2" === str_mode || "3" === str_mode || ("1" === str_mode && arr_time_set[idx]
                    // 暂时逻辑 工作模式为1/0->根据是否启用进行 0时只发表达式 ((0:0:1|1|1|1|1|),....)无参数 1->需分析参数下发
                    // if ("0" !== str_mode) {
                    var arr_box_offset = mc_deal_box_offset(str_mode, str_time_data, str_curr_s_id, obj_screen_param);

                    obj_data.OFFSET[0] = arr_box_offset[0];
                    obj_data.OFFSET[1] = arr_box_offset[1];
                    obj_data.OFFSET[2] = arr_box_offset[2];

                    break;
                case "BRIGHT":
                    if ("0" !== str_mode) {
                        var arr_box_bright = mc_deal_gm_gu_br("bright", str_mode, str_time_data, obj_param_all, str_curr_s_id);

                        obj_data.BRIGHT[0] = arr_box_bright[0];
                        obj_data.BRIGHT[1] = arr_box_bright[1];
                        obj_data.BRIGHT[2] = arr_box_bright[2];
                    }
                    break;
                case "GAMMA":
                    if ("0" !== str_mode) {
                        var arr_box_gamma = mc_deal_gm_gu_br("gamma", str_mode, str_time_data, obj_param_all, str_curr_s_id);

                        obj_data.GAMMA[0] = arr_box_gamma[0];
                        obj_data.GAMMA[1] = arr_box_gamma[1];
                        obj_data.GAMMA[2] = arr_box_gamma[2];
                    }
                    break;
                case "GAMUT":
                    if ("0" !== str_mode) {
                        var arr_box_balance = mc_deal_gm_gu_br("balance", str_mode, str_time_data, obj_param_all, str_curr_s_id);

                        obj_data.GAMUT[0] = arr_box_balance[0];
                        obj_data.GAMUT[1] = arr_box_balance[1];
                        obj_data.GAMUT[2] = arr_box_balance[2];
                    }

                    break;
                case "BOX":
                    // 处理箱体数据
                    // 暂时逻辑 工作模式为1/0->根据是否启用进行 0时只发表达式 ((0:0:1|1|1|1|1|),....)无参数 1->需分析参数下发
                    if ("0" !== str_mode) {
                        var arr_box_param = mc_deal_box_param(str_mode, str_time_data, str_curr_s_id, obj_screen_param, obj_param_all.box);

                        obj_data.BOX[0] = arr_box_param[0];
                        obj_data.BOX[1] = arr_box_param[1];
                        obj_data.BOX[2] = arr_box_param[2];
                    }

                    break;
                default:
                    break;
            }
        }
    }

    return obj_data;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理时间数据
 * 参数:
 *    @param {Promise<object>} obj_data   储存时间对象 obj_param_all.time.time 索引对应的时间参数
 *    @param {Promise<string>} key   索引 "offset" / "bright" /...

 * 返回：
 *    @returns  {Promise<String>} str 时间 (ms)

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.04.07
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_time(obj_data, key) {
    // 时间
    var str_time = "";
    var arr_time = [];
    var ui_h = 0;
    var ui_min = 0;
    var ui_s = 0;

    // 暂处理识别对象参数
    switch (key) {
        case "SENDCARD_OUTPORT":
            key = "send_port";
            break;
        case "HUBCARD_OUTPORT":
            key = "hub_port";
            break;
        case "OFFSET":
            key = "offset";
            break;
        case "BRIGHT":
            key = "bright";
            break;
        case "GAMMA":
            key = "gamma";
            break;
        case "GAMUT":
            key = "balance";
            break;
        case "BOX":
            key = "box_params";
            break;

        default:
            break;
    }


    // 获取时间的索引
    for (var key_t in obj_data) {
        if (obj_data.hasOwnProperty(key_t)) {
            if (key_t === key) {
                arr_time = obj_data[key_t].split(":");
            }
        }
    }

    ui_h = Number(arr_time[0]);
    ui_min = Number(arr_time[1]);
    ui_s = Number(arr_time[2]);

    str_time = ((ui_s + ui_min * 60 + ui_h * 3600) * 1000).toString();

    return str_time;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理模式 每个参数可能出现不同模式
 * 参数:
 *    @param {Promise<number>} idx   索引 "offset" / "bright" /...
 *    @param {Promise<object>} obj_param_all   对象
 *    @param {Promise<string>} str_type   work_mode 模式
 *    @param {Promise<string>} key   界面参数

 * 返回：
 *    @returns  {Promise<String>} str 表达式的模式

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.04.07
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_deal_mode(idx, obj_param_all, str_type, key) {
    var str = str_type;

    if ("0" === str_type) {
        return str;
    }
    var arr_time_set = obj_param_all.check;

    if ("1" === str_type) {
        if (arr_time_set[idx]) {
            str = "1";
        } else {
            str = "0";
        }
    }

    if ("2" === str_type || "3" === str_type) {
        var str_time = mc_set_time(obj_param_all.time, key);

        if ("0" !== str_time) {
            str = "3";
        } else {
            str = "2";
        }
    }


    return str;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理矫正数据
 * 参数:
 *    @param {Promise<String>} arr   存储的矫正数据

 * 返回：
 *    @returns  {Promise<String>} str 处理后的矫正数据

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.04.07
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_deal_gaumt(arr) {
    var str = "";

    arr[0] = arr[0].replace(/\s*/g, "");
    arr[1] = arr[1].replace(/\s*/g, "");
    arr[2] = arr[2].replace(/\s*/g, "");
    arr[3] = arr[3].replace(/\s*/g, "");
    arr[4] = arr[4].replace(/\s*/g, "");
    arr[5] = arr[5].replace(/\s*/g, "");
    arr[6] = arr[6].replace(/\s*/g, "");
    arr[7] = arr[7].replace(/\s*/g, "");
    arr[8] = arr[8].replace(/\s*/g, "");

    str = "(" + arr[0] + ":" + arr[1] + ":" + arr[2] + ":" + arr[3] + ":" + arr[4] + ":" + arr[5] + ":" + arr[6] + ":" + arr[7] + ":" + arr[8] + ")";
    return str;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取gamma值
 * 参数:
 *    @param { Promise<String> } str_ctrl 下发参数
 *    @param { Promise<Array> } arr_box_name 主控名称
 *    @param { Promise<String> } funk_callback 回调
 * 备注:
 *      获取顺序 : 1.箱体应用的gamma
 *                2.箱体默认表
 *                3.计算表
 *      有则获取无则往下拿
 *
 *      存在多个箱体 默认先使用第一个箱体的gamma
 * 返回：
 *    NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.04.07
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_gamma(str_ctrl, arr_box_name, funk_callback) {
    var str = "";
    var arr_box_data = parent.ARY_BOX_DATA;
    var str_box_name = "";
    var str_exist_box_name = "";
    // var obj_gamma_param = {};

    for (var id_box = 0; id_box < arr_box_name.length; id_box++) {
        str_box_name = arr_box_name[id_box].toLocaleUpperCase();

        for (var idx_exist_box = 0; idx_exist_box < arr_box_data.length; idx_exist_box++) {
            str_exist_box_name = arr_box_data[idx_exist_box].name.toLocaleUpperCase();
            if (str_box_name === str_exist_box_name) {
                if (0 === arr_box_data[idx_exist_box].data.mc_util_get_gamma_val().length) {
                    continue;
                }
                // 看是否存在数据
                if (arr_box_data[idx_exist_box].data.mc_util_get_gamma_val()[0].data) {
                    str = arr_box_data[idx_exist_box].data.mc_util_get_gamma_val()[0].data;
                    // obj_gamma_param = arr_box_data[idx_exist_box].data.mc_util_get_gamma_val()[0];
                    break;
                }
            }
        }
        if (str) {
            funk_callback([true, str]);
            return;
        }
    }

    if (0 !== arr_box_data.length) {
        // 获取箱体表
        mc_read_box_gamma(str_ctrl, function (obj_box_gam) {
            if (obj_box_gam.str_gamma_r) {
                str = obj_box_gam.str_gamma_r;
                funk_callback([true, str]);
            } else {
                mc_get_cal_gamma(function (str_cal) {
                    str = str_cal;
                    if (str) {
                        funk_callback([true, str]);
                    } else {
                        funk_callback([false, "MC_LANG_GAMMA_MAX_GET_GAMMA_FAIL"]);
                    }
                }, arr_box_data[0].data.mc_util_get_gamma_val());
                return;
            }
            return;
        });
    } else {
        funk_callback([false, "MC_LANG_GAMMA_MAX_GET_GAMMA_FAIL"]);
        return;
    }

    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    关闭亮度自动亮度
 * 参数:
 *    @param { Promise<String> } str_fun 下发参数
 *    @param { Promise<String> } str_chip_name 主控名称
 *    @param { Promise<String> } fun_callback 回调
 * 返回:
 *    @fun_callback  NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-07
 *       内容 : 所有代码
************************************************************************************************/
function mc_close_auto_bright(str_fun, str_chip_name, fun_callback) {
    var obj_req = new mc_sdk_param();

    var Str_funk_card_order = "0:0:0:0:0";
    var Str_order = "-1:-1:-1:-1:-1";

    obj_req.set_param_clear();
    obj_req.set_cmd("SET_PARAM");
    obj_req.set_func(str_fun);
    obj_req.set_param_value(Str_funk_card_order, Str_order);

    // obj_req.set_attr_val(Str_funk_card_order, "BRIGHT_STEP", "");
    obj_req.set_attr_val(Str_funk_card_order, "SENDCARD_ENABLE", "0");
    obj_req.set_attr_val(Str_funk_card_order, "SW_ENABLE", "0");
    obj_req.set_attr_val(Str_funk_card_order, "CHIPNAME", str_chip_name);

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        fun_callback();
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析大屏界面数据
 * 参数:
 *    @param { Promise<object> } obj 下发参数
 * 返回:
 *    @returns  { Promise<object> } obj_return 下发参数
 * 例子:
 *    NA
 * 备注:
 *    解析界面dom元素 获取 偏移/接收卡名称/箱体名称
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-07
 *       内容 : 所有代码
************************************************************************************************/
function mc_deal_screen_data(obj) {
    var str_key = "";
    var str_each_key = "";
    var str_offset = "";
    var str_box_name = "";
    var str_chip_name = "";
    var obj_return = {};

    for (var key in obj) {
        if (0 === obj[key].length) {
            continue;
        }

        // 解析key
        str_key = mc_deal_screen_order(key); //0:0:0:0
        var arr_each_recv_data = obj[key];
        var ui_each_recv_data_length = arr_each_recv_data.length;

        // 获取当前位置下所有接收卡数据
        for (var idx = 0; idx < ui_each_recv_data_length; idx++) {
            str_each_key = str_key + ":" + idx;
            // 箱体dom对象 第一层
            var html_dom_each = arr_each_recv_data[idx][0];

            str_box_name = html_dom_each.getAttribute("mod_id");
            // 箱体dom对象 第二层 偏移/接收卡名称
            str_offset = html_dom_each.getElementsByClassName("mod_pot")[0].innerText;
            str_offset = str_offset.replace(/,/g, ":");
            str_offset = "(0:0:" + str_offset + ")";
            str_chip_name = html_dom_each.getElementsByClassName("chip_name")[0].innerText;

            obj_return[str_each_key] = {
                "rece_name": str_chip_name,
                "offset": str_offset,
                "str_box_name": str_box_name
            };
        }
    }

    return obj_return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理大屏界面位置指令
 * 参数:
 *    @param { Promise<string> } str 大屏位置指令
 * 返回:
 *    @returns  { Promise<string> } str_data 解析后的大屏指令
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-08
 *       内容 : 所有代码
************************************************************************************************/
function mc_deal_screen_order(str) {
    var str_data = str.replace(/[a-zA-Z]/g, "");
    var arr_data = [];
    var arr_hub_data = [];

    if (str_data.includes("_")) {
        arr_data = str_data.split("_");
        arr_hub_data = arr_data[2].split(":");
        str_data = (Number(arr_data[0]) - 1) + ":" + (Number(arr_data[1]) - 1) + ":" + (Number(arr_hub_data[0]) - 1) + ":" + (Number(arr_hub_data[1]) - 1);
    } else {
        arr_data = str_data.split(":");
        str_data = (Number(arr_data[0]) - 1) + ":" + (Number(arr_data[1]) - 1) + ":-1:-1";
    }

    return str_data;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取所有箱体名称 (排除相同)
 * 参数:
 *    @param { Promise<object> } obj_data 大屏位置指令
 *    @param { Promise<Array> } arr_order 当前下发的指令
 * 返回:
 *    @returns  { Promise<Array> } arr_data 所有箱体名称
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-08
 *       内容 : 所有代码
************************************************************************************************/
function mc_get_all_box_name(obj_data, arr_order) {
    var arr_data = [];
    var str_box_name = "";

    for (var key in obj_data) {
        if (obj_data.hasOwnProperty(key)) {
            for (var id = 0; id < arr_order.length; id++) {
                if (key === arr_order[id]) {
                    str_box_name = obj_data[key].str_box_name;
                }
            }
            if (arr_data.includes(str_box_name)) {
                continue;
            }
            arr_data.push(str_box_name);
        }
    }

    // var ui_box_length = arr_data.length
    // if (ui_box_length <= 1) {
    //   return arr_data;
    // }
    // // 排序
    // for (var idx = 0; idx < ui_box_length; idx++) {
    //   const element = array[idx];

    // }

    return arr_data;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取所有下发的指令下对应的发送卡名称
 * 参数:
 *    @param { Promise<function> } fun_callback 回调
 * 返回:
 *    @param { Promise<Array> } arr_send_req 所有发送卡名称
 * 例子:
 *    NA
 * 备注:
 *    格式 : {key:[s_name,h_name]}
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-09
 *       内容 : 所有代码
************************************************************************************************/
function mc_get_send_name(fun_callback) {
    // 获取发送卡名称
    mc_get_send_card_list(function (arr_send_req) {
        // 判断是否为空
        if (0 === arr_send_req.length) {
            fun_callback("MC_LANG_INSPECTION_NO_SEND_NAME");
            return;
        }
        fun_callback(arr_send_req);
        return;
    });
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取所有下发的指令下对应的发送卡 hub卡可能有可能无
 * 参数:
 *    @param { Promise<function> } fun_callback 回调
 * 返回:
 *    @param { Promise<Array> } arr 大屏位置指令
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-09
 *       内容 : 所有代码
************************************************************************************************/
function mc_get_send_card_list(fun_callback) {
    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("HW_SENDCARD_CONNECT");

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        var obj_res = new mc_sdk_param();

        obj_res.set_param_clear();
        obj_res.set_json(result);

        var arr_return_s_name = [];

        var ui_param_cnt = obj_res.get_param_cnt();
        var str_param_name = "";
        var str_param_val = "";

        for (var idx = 0; idx < ui_param_cnt; idx++) {
            str_param_name = obj_res.get_param_name(idx);
            if ("ERROR_CODE" === str_param_name) {
                continue;
            }
            str_param_val = obj_res.get_param_value(str_param_name);

            arr_return_s_name.push(str_param_val.split(":")[0]);
        }

        fun_callback(arr_return_s_name);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取所有下发的指令下对应的hub卡名称 hub卡可能有可能无
 * 参数:
 *    @param { Promise<function> } fun_callback 回调
 *    @param { Promise<string> } str_order 硬件指令
 * 返回:
 *    @fun_callback  { Promise<Array> } arr 大屏位置指令
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-09
 *       内容 : 所有代码
************************************************************************************************/
function mc_get_hub_card_list(fun_callback, str_order) {
    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("HW_HUBCARD_CONNECT");
    obj_req.set_param_value("HUB_N", str_order);

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        var obj_res = new mc_sdk_param();

        obj_res.set_param_clear();
        obj_res.set_json(result);

        var str_hub_name = "";
        var arr_hub_name = [];
        var ui_param_cnt = obj_res.get_param_cnt();
        var str_param_name = "";

        for (var idx = 0; idx < ui_param_cnt; idx++) {
            str_param_name = obj_res.get_param_name(idx);
            if ("ERROR_CODE" === str_param_name) {
                continue;
            }

            str_hub_name = obj_res.get_attr_val(str_param_name, "STATUS");
            // 多个情况下
            if (str_hub_name.includes(",")) {
                var arr_each = str_hub_name.split(",");

                for (var id = 0; id < arr_each.length; id++) {
                    arr_hub_name.push(arr_each[id].split(":")[0]);
                }
            } else {
                arr_hub_name = [str_hub_name.split(":")[0]];
            }
        }

        fun_callback(arr_hub_name);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理hub卡名称 (针对串联时数据的获取)
 * 参数:
 *    @param { Promise<object> } obj_data hub卡数据
 * 返回:
 *    @returns  { Promise<Array> } arr 大屏位置指令
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-09
 *       内容 : 所有代码
************************************************************************************************/
function mc_deal_hub_name(obj_data) {
    var obj_return = {};

    obj_return = obj_data;
    var str_each_order = "";
    var arr_each_order = [];
    var ui_hub_data = 0;
    // 赋值hub名称

    for (var key in obj_return) {
        if (obj_return.hasOwnProperty(key)) {
            // 没有hub卡的情况
            if (!obj_return[key][2]) {
                continue;
            }

            if (0 < obj_return[key][2].length) {
                // 判断hub值
                str_each_order = key;
                arr_each_order = str_each_order.split(":");
                ui_hub_data = Number(arr_each_order[2]);

                if (!obj_return[key][2][ui_hub_data]) {
                    continue;
                }
                obj_return[key][1] = obj_return[key][2][ui_hub_data];
            }
        }
    }
    return obj_return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理界面显示 查看是否开启未设置时间
 * 参数:
 *    @param { Promise<object> } obj 回调
 * 返回:
 *    @return { Promise<boolean> }  是否已经关闭 false 代表开启已设置时间 传MC_LANG的代表时间未设置
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-16
 *       内容 : 所有代码
************************************************************************************************/
function mc_if_set_time(obj) {
    var arr_check = obj.check;
    var arr_time = [obj.time.send_port, obj.time.hub_port, obj.time.offset, obj.time.bright, obj.time.gamma, obj.time.balance, obj.time.box_params];
    var arr_type = ["MC_LANG_INSPECTION_SEND_PORT_TIME_NOT_SET", "MC_LANG_INSPECTION_HUB_PORT_TIME_NOT_SET", "MC_LANG_INSPECTION_OFFSET_TIME_NOT_SET", "MC_LANG_INSPECTION_BRIGHT_TIME_NOT_SET", "MC_LANG_INSPECTION_GAMMA_TIME_NOT_SET", "MC_LANG_INSPECTION_GAUMT_TIME_NOT_SET", "MC_LANG_INSPECTION_BOX_TIME_NOT_SET"];

    for (var idx = 0; 7 > idx; idx++) {
        var b_each = arr_check[idx];

        if (b_each) {
            // 判断是否为 00:00:00
            if ("00:00:00" === arr_time[idx]) {
                return arr_type[idx];
            }
        }
    }

    return false;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    检测是否开启任意一个按钮 (后期添加硬件按钮)
 * 参数:
 *    @param { Promise<object> } obj 回调
 * 返回:
 *    @return { Promise<boolean> }  是否已经关闭 false true
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-17
 *       内容 : 所有代码
************************************************************************************************/
function mc_send_hw_soft(obj) {
    // var arr_check = obj.check;

    // if (!arr_check[0] && !arr_check[1] && !arr_check[2] && !arr_check[3] && !arr_check[4]) {
    //     return false;
    // }
    // return true;
    var b_hw = obj.hw_switch;
    var b_soft = obj.soft_switch;

    if (!b_hw && !b_soft) {
        return "0";
    }
    if (!b_hw && b_soft) {
        return "1";
    }
    if (b_hw && !b_soft) {
        return "2";
    }
    if (b_hw && b_soft) {
        return "3";
    }
    return "0";
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    检测是否开启任意一个按钮 (后期添加硬件按钮)
 * 参数:
 *    @param { Promise<object> } obj 回调
 * 返回:
 *    @return { Promise<boolean> }  是否已经关闭 false true
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-17
 *       内容 : 所有代码
************************************************************************************************/
function mc_if_open_time(obj) {
    var arr_check = obj.check;

    if (!arr_check[1] && !arr_check[2] && !arr_check[3] && !arr_check[4] && !arr_check[5] && !arr_check[6]) {
        return false;
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理界面显示 查看是否开启未设置时间
 * 参数:
 *    @param { Promise<object> } obj 回调
 * 返回:
 *    @return { Promise<boolean> }  是否已经关闭 false true
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-16
 *       内容 : 所有代码
************************************************************************************************/
function mc_analysic_screen_data(obj) {
    var b_exist = true;

    if ("{}" === JSON.stringify(obj)) {
        return b_exist;
    }

    for (var key in obj) {
        if (0 < obj[key].length) {
            b_exist = false;
            return b_exist;
        }
    }

    return b_exist;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理每张发送卡下是否接收卡一致
 * 参数:
 *    @param { Promise<Array> } arr_order 指令参数
 *    @param { Promise<object> } obj 回调
 * 返回:
 *    @return { Promise<boolean> }  是否已经关闭 false true
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-16
 *       内容 : 所有代码
************************************************************************************************/
function mc_deal_recv_card_name(arr_order, obj) {
    var arr_all = [];
    var arr_each = [];
    var ui_all_length = arr_order.length;

    if (0 === ui_all_length) {
        return "";
    }
    var arr_retrun = [];

    // NO.1 分解数据
    // 指令第一位数值
    var str_s_id_prev = arr_order[0].split(":")[0];
    var str_s_id = "";

    for (var idx = 0; idx < ui_all_length; idx++) {
        str_s_id = arr_order[idx].split(":")[0];
        if (str_s_id === str_s_id_prev) {
            arr_each.push(arr_order[idx]);
        } else {
            //不同情况
            arr_all.push(arr_each);
            arr_each = JSON.parse(JSON.stringify(arr_each));
            arr_each = [arr_order[idx]];
        }

        // 最后一个
        if (ui_all_length - 1 === idx) {
            arr_all.push(arr_each);
        }

        str_s_id_prev = str_s_id;
    }

    // NO.2 判断每个发送卡下设置的接收卡参数是否一致
    // 解析当前发送卡数量
    var ui_s_length = arr_all.length;

    // 判断当前发送卡下是否存在不同的接收卡名称
    for (var idx_s = 0; idx_s < ui_s_length; idx_s++) {
        var arr_each_s_order = arr_all[idx_s];
        var str_rece_name_prev = obj[arr_each_s_order[0]].rece_name;
        var str_first_rece_name = obj[arr_each_s_order[0]].rece_name;

        for (var id_each_order = 1; id_each_order < arr_each_s_order.length; id_each_order++) {
            str_first_rece_name = obj[arr_each_s_order[id_each_order]].rece_name;
            if (str_first_rece_name === str_rece_name_prev) {
                str_rece_name_prev = str_first_rece_name;
                continue;
            } else {
                return "";
            }
        }
    }

    // NO.3 将每张发送卡下的接收卡以数组形式存储 默认获取第一张接收卡名称
    // 获取对应发送卡下的接收卡
    for (var id = 0; id < ui_s_length; id++) {
        arr_retrun.push(obj[arr_all[id][0]].rece_name);
    }

    return arr_retrun;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取对应发送卡下的箱体参数 设置当前发送卡下的箱体参数
 * 参数:
 *    @param { Promise<string> } str_mode 工作模式 用于表达式
 *    @param { Promise<string> } str_time_data 时间参数 用于表达式
 *    @param { Promise<number> } ui_idx 发送卡位置索引
 *    @param { Promise<object> } obj_screen_param 大屏界面参数 用于确定当前指令的箱体名称
 *    @param { Promise<object> } obj_box 箱体请求回来的参数
 * 返回:
 *    @return { Promise<Array> }  ['表达式',[ 索引 ],[ 对应索引的箱体参数 ]]
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-16
 *       内容 : 所有代码
************************************************************************************************/
function mc_deal_box_param(str_mode, str_time_data, ui_idx, obj_screen_param, obj_box) {
    // 存放需要下发的参数
    var str_params_press = "";
    var arr_idx = [];
    var arr_box = [];
    var arr_order = [];
    var arr_box_name = [];
    var obj_all_box = {};
    var str_box_name = "";
    var arr_return = ["", [], []];
    // var ui_box_cnt = 0;

    // 设置当前所有箱体的参数
    // eslint-disable-next-line guard-for-in
    for (var key_box in obj_box) {
        obj_all_box[key_box] = [];
        // ui_box_cnt++;
    }

    // 筛选出当前对应发送卡下的箱体
    // eslint-disable-next-line guard-for-in
    for (var key in obj_screen_param) {
        // if (Number(key.split(":")[0]) === ui_idx) {
        //     arr_order.push(key);
        //     arr_box_name.push(obj_screen_param[key].str_box_name);
        // }
        arr_order.push(key);
        arr_box_name.push(obj_screen_param[key].str_box_name);
    }

    // 筛选出所有相同箱体的指令模块
    for (var id = 0; id < arr_box_name.length; id++) {
        str_box_name = arr_box_name[id];
        // 根据当前箱体一样的进行设置
        obj_all_box[str_box_name].push(arr_order[id]);
    }

    // 处理箱体下发指令 能避免发所有则避免
    var obj_all_box_new = mc_handle_box_order(obj_all_box);

    // 设置参数 循环已拿的箱体数量
    // eslint-disable-next-line guard-for-in
    for (var idx in obj_all_box_new) {
        var arr_each = obj_all_box_new[idx];
        var ui_length = arr_each.length;

        if (0 === ui_length) {
            continue;
        }
        var str_idx = "|BOX" + ui_box_idx;

        if ("0" === str_mode) {
            str_idx = "";
        }
        for (var id_box = 0; id_box < ui_length; id_box++) {
            var str_each_prese = "(";

            str_each_prese = "(" + str_mode + ":" + str_time_data + ":" + arr_each[id_box].replace(/:/g, "|") + str_idx + "),";

            str_params_press += str_each_prese;
        }

        arr_idx.push(str_idx.slice(1));
        arr_box.push(obj_box[idx]);
        ui_box_idx++;
    }
    str_params_press = str_params_press.slice(0, -1);
    arr_return[0] = str_params_press;
    arr_return[1] = arr_idx;
    arr_return[2] = arr_box;
    return arr_return;
}

// 处理下发巡检箱体指令
function mc_handle_box_order(obj_data) {
    var obj_return = {};
    var arr_all_box = Object.keys(obj_data);
    var ui_all_box = arr_all_box.length;

    if (1 === ui_all_box) {
        var str_box_name = arr_all_box[0];
        // 获取当前界面设置的发送卡 只有一个
        var str_order = obj_data[str_box_name][0];

        // 有则拿界面 无则拿已选中的发送卡
        if (str_order) {
            str_order = str_order.split(":")[0];
            str_order += ":-1:-1:-1:-1";
        } else {
            str_order = idx_s + ":-1:-1:-1:-1";
        }
        obj_return[str_box_name] = [str_order];

        return obj_return;
    }

    // 多种箱体
    // 先比较同一箱体下的所有指令 相同位置进行比较 再看其他箱体的指令 是否存在差异 存在差异则用原始的 不存在则可以改成-1
    var b_same = true;
    // 轮次 分4轮
    var b_smae_round = false;
    var str_first_val = "";

    // 轮四条线 除了主控
    for (var id_cnt = 0; 4 > id_cnt; id_cnt++) {
        b_smae_round = false;
        b_same = true;
        // 轮询所有箱体
        for (var id_box_cnt = 0; id_box_cnt < ui_all_box; id_box_cnt++) {
            var str_each_box_name = arr_all_box[id_box_cnt];
            var arr_box_order = obj_data[str_each_box_name];

            if (!b_same) {
                break;
            }
            for (var id_each_box_order = 0; id_each_box_order < arr_box_order.length; id_each_box_order++) {
                if (0 === id_each_box_order && !b_smae_round) {
                    str_first_val = arr_box_order[0].split(":")[id_cnt + 1];
                    // 每次获取第一个值 则表示同一轮
                    b_smae_round = true;
                    continue;
                }
                var str_each_val = arr_box_order[id_each_box_order].split(":")[id_cnt + 1];

                if (str_each_val !== str_first_val) {
                    b_same = false;
                    break;
                }

                str_first_val = str_each_val;
            }
        }

        // 轮询每次结束后
        if (b_same) {
            // 当条线所有箱体都相同
            // 修改当条线的所有箱体的所有指令的位置
            for (var id_chg_box = 0; id_chg_box < ui_all_box; id_chg_box++) {
                var str_each_box = arr_all_box[id_chg_box];
                var arr_each_box_order = obj_data[str_each_box];
                var ui_each_order_cnt = arr_each_box_order.length;

                for (var id_chg_order = 0; id_chg_order < ui_each_order_cnt; id_chg_order++) {
                    var arr_new_order = arr_each_box_order[id_chg_order].split(":");

                    arr_new_order[id_cnt + 1] = "-1";
                    var str_new_order = arr_new_order.toString().replaceAll(",", ":");

                    // 赋新值
                    arr_each_box_order[id_chg_order] = str_new_order;
                }
            }
            obj_return = obj_data;
        }
    }

    if (0 === Object.keys(obj_return).length) {
        obj_return = obj_data;
    }

    return obj_return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取对应发送卡下的箱体偏移 解析界面数据
 * 参数:
 *    @param { Promise<string> } str_mode 工作模式 用于表达式
 *    @param { Promise<string> } str_time_data 时间参数 用于表达式
 *    @param { Promise<number> } ui_idx 发送卡位置索引
 *    @param { Promise<object> } obj_screen_param 大屏界面参数 用于确定当前指令的箱体名称
 * 返回:
 *    @return { Promise<Array> }  ['表达式',[ 索引 ],[ 对应索引的箱体参数 ]]
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-17
 *       内容 : 所有代码
************************************************************************************************/
function mc_deal_box_offset(str_mode, str_time_data, ui_idx, obj_screen_param) {
    // 所有当前发送卡下的所有箱体的指令
    var arr_order = [];
    // 返回内容
    var arr_return = ["", [], []];
    // 返回数据 表达式 索引 索引下的偏移
    var str_params_press = "";
    var arr_ui = [];
    var arr_offset = [];

    // 存储每个箱体数据
    var str_each_order = "";
    var str_each_offset = "";
    var str_each_prese = "";

    // 筛选出当前对应发送卡下的箱体
    for (var key in obj_screen_param) {
        // if (Number(key.split(":")[0]) === ui_idx) {
        // }
        arr_order.push(key);
    }

    var ui_length = arr_order.length;
    // 根据已筛选的数据进行分配

    for (var idx = 0; idx < ui_length; idx++) {
        str_each_order = arr_order[idx];
        str_each_offset = obj_screen_param[str_each_order].offset;

        var str_idx = "|OS" + ui_offset_id;

        if ("0" === str_mode) {
            str_idx = "";
        }
        str_each_prese = "(" + str_mode + ":" + str_time_data + ":" + str_each_order.replace(/:/g, "|") + str_idx + "),";

        str_params_press += str_each_prese;


        // 添加对应索引及参数 关闭状态不保存索引跟参数
        if ("0" !== str_mode) {
            ui_offset_id++;
            arr_ui.push(str_idx.slice(1));
            arr_offset.push(str_each_offset);
        }
    }

    str_params_press = str_params_press.slice(0, -1);
    arr_return[0] = str_params_press;
    arr_return[1] = arr_ui;
    arr_return[2] = arr_offset;

    return arr_return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取对应发送卡下的箱体偏移 解析界面数据
 * 参数:
 *    @param { Promise<string> } id_type 参数标识
 *    @param { Promise<string> } str_mode 工作模式 用于表达式
 *    @param { Promise<string> } str_time_data 时间参数 用于表达式
 *    @param { Promise<object> } obj_param_all 大屏界面参数 用于确定当前指令的箱体名称
 *    @param { Promise<string> } id_curr_s_id 当前大屏设置的发送卡索引
 * 返回:
 *    @return { Promise<Array> }  ['表达式', '索引' , '对应索引的箱体参数' ]
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-04-17
 *       内容 : 所有代码
************************************************************************************************/
function mc_deal_gm_gu_br(id_type, str_mode, str_time_data, obj_param_all, id_curr_s_id) {
    var arr_return = ["", [], []];
    var str_order = "";

    switch (id_type) {
        case "bright":
            str_order = "|BG" + id_curr_s_id;
            if ("0" === str_mode) {
                str_order = "";
            }
            arr_return[0] = "(" + str_mode + ":" + str_time_data + ":" + id_curr_s_id + "|-1|-1|-1|-1" + str_order + ")";
            arr_return[1] = ["BG" + id_curr_s_id];
            arr_return[2] = [obj_param_all.bright];
            break;
        case "gamma":
            str_order = "|GM" + id_curr_s_id;
            if ("0" === str_mode) {
                str_order = "";
            }
            arr_return[0] = "(" + str_mode + ":" + str_time_data + ":" + id_curr_s_id + "|-1|-1|-1|-1" + str_order + ")";
            arr_return[1] = ["GM" + id_curr_s_id];
            arr_return[2] = [obj_param_all.gamma];
            break;
        case "balance":
            str_order = "|GU" + id_curr_s_id;
            if ("0" === str_mode) {
                str_order = "";
            }
            arr_return[0] = "(" + str_mode + ":" + str_time_data + ":" + id_curr_s_id + "|-1|-1|-1|-1" + str_order + ")";
            arr_return[1] = ["GU" + id_curr_s_id];
            arr_return[2] = [obj_param_all.gaumt];
            break;

        default:
            break;
    }

    // 关闭模式下参数无效
    if ("0" === str_mode) {
        arr_return[1] = [];
        arr_return[2] = [];
    }

    return arr_return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取对应发送卡下的箱体偏移 解析界面数据
 * 参数:
 *    @param { Promise<string> } str_mode 工作模式 用于表达式
 *    @param { Promise<string> } str_time_data 时间参数 用于表达式
 *    @param { Promise<object> } obj_s_h_outport 大屏获取的输出口图像数据
 *    @param { Promise<string> } str_mark 标识 处理主控分控 send主控/hub分控
 * 返回:
 *    @return { Promise<Array> }  ['表达式', '索引' , '对应索引的箱体参数' ]
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-09-06
 *       内容 : 所有代码
************************************************************************************************/
function mc_deal_s_h_port(str_mode, str_time_data, obj_s_h_outport, str_mark) {
    // 返回内容
    var arr_return = ["", [], []];
    // 返回数据 表达式 索引 索引下的偏移
    var str_params_press = "";
    var arr_ui = [];
    var arr_data = [];

    var arr_curr_deal = obj_s_h_outport[str_mark];
    var ui_len = arr_curr_deal.length;
    var str_id_name = "SP";

    if ("h_outport" === str_mark) {
        str_id_name = "HP";
    }

    for (var idx = 0; idx < ui_len; idx++) {
        var str_each_order = arr_curr_deal[idx].PARAM;

        if ("s_outport" === str_mark) {
            str_each_order += "|-1|-1|-1|-1|";
        } else {
            var arr_hub_split = str_each_order.split(":");

            str_each_order = arr_hub_split[0] + "|" + arr_hub_split[1] + "|" + arr_hub_split[2] + "|-1|-1|";
        }


        var str_each_val = arr_curr_deal[idx].STR_IMG;

        var str_idx = str_id_name + idx;

        if ("0" === str_mode) {
            str_idx = "";
        }
        var str_each_prese = "(" + str_mode + ":" + str_time_data + ":" + str_each_order + str_idx + "),";

        str_params_press += str_each_prese;


        // 添加对应索引及参数 关闭状态不保存索引跟参数
        if ("0" !== str_mode) {
            arr_ui.push(str_idx);
            arr_data.push(str_each_val);
        }
    }

    str_params_press = str_params_press.slice(0, -1);
    arr_return[0] = str_params_press;
    arr_return[1] = arr_ui;
    arr_return[2] = arr_data;

    return arr_return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读取箱体GAMMA表(回读)
 * 参数:
 *    @param {Promise<StringConstructor>} str_cur_ctrl_card    主控芯片名称 (可能没有)
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<Number>}
 *    @param {Promise<array>}
 *    @param {Promise<array>}
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.09.10
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_read_box_gamma(str_cur_ctrl_card, fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }
    var str_box_gamma_json_req = new mc_sdk_param();

    str_box_gamma_json_req.set_param_clear();
    str_box_gamma_json_req.set_cmd("GET_PARAM");
    str_box_gamma_json_req.set_func("HW_BOX_GAMA");
    str_box_gamma_json_req.set_param_value("RECVCARD", "0:-1:-1:-1:-1");
    str_box_gamma_json_req.set_attr_val("RECVCARD", "CHIPNAME", str_cur_ctrl_card);
    str_box_gamma_json_req.set_attr_val("RECVCARD", "MEMTYPE", "RAM");

    $.post("/access_shell", str_box_gamma_json_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obj_param_box_gamma = new mc_sdk_param();

        obj_param_box_gamma.set_json(result);
        var str_val_json = obj_param_box_gamma.get_param_value("RW_DATA");
        var obj_color = new mc_sdk_param();

        obj_color.set_json(str_val_json);
        var str_gamma_r = obj_color.get_param_value("R");
        // var str_gamma_g = obj_param_box_gamma.get_param_value("GAMA_G");
        // var str_gamma_b = obj_param_box_gamma.get_param_value("GAMA_B");
        var str_gamma_id = obj_param_box_gamma.get_param_value("GAMA_ID");
        var str_error = obj_param_box_gamma.get_param_value("ERROR_CODE");

        var obj_box_gamma = {
            "str_gamma_r": str_gamma_r,
            // "str_gamma_g": str_gamma_g,
            // "str_gamma_b": str_gamma_b,
            "str_gamma_id": str_gamma_id,
            "error": str_error
        };


        fun_callback(obj_box_gamma);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取gamma默认表 拿到初始数据 并处理
 * 参数:
 *    @param {Promise<function>} fun_callback  回调函数
 *    @param {Promise<object>} obj_gamma_param  gama基本参数 默认只拿第一个箱体的gamma应用
 * 返回：
 *      String : gamma值
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.09.10
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_get_cal_gamma(fun_callback, obj_gamma_param) {
    var str_url_gama_mode_value = "";
    var str_url_gray_bit_size = "";
    var str_max_val = "";
    var str_url_gamma_factor = "";

    // 存在则用存在的

    if (obj_gamma_param[0]) {
        str_url_gray_bit_size = obj_gamma_param.gray_bit;
        str_url_gamma_factor = obj_gamma_param.factor;
        str_url_gama_mode_value = obj_gamma_param.mode_val_idx;
        str_max_val = obj_gamma_param.y_val;
    }


    if ("string" !== typeof str_url_gray_bit_size || 0 >= str_url_gray_bit_size.length) {
        str_url_gray_bit_size = "12";
    }


    if ("string" !== typeof str_url_gamma_factor || 1 > parseFloat(str_url_gamma_factor) || 4 < parseFloat(str_url_gamma_factor) || 0 >= str_url_gamma_factor.length) {
        str_url_gamma_factor = "2.8";
    }


    if ("string" !== typeof str_url_gama_mode_value || 0 > parseInt(str_url_gama_mode_value, 10) || 2 < parseInt(str_url_gama_mode_value, 10)) {
        str_url_gama_mode_value = "1";
    }
    if ("string" !== typeof str_max_val || 0 > parseInt(str_max_val, 10)) {
        str_max_val = "65535";
    }

    var str_default_gamma_json_req = new mc_sdk_param();

    str_default_gamma_json_req.set_param_clear();
    str_default_gamma_json_req.set_cmd("GET_PARAM");
    str_default_gamma_json_req.set_func("GAMA_TABLE");
    str_default_gamma_json_req.set_param_value("GAMA_MODE", str_url_gama_mode_value);
    str_default_gamma_json_req.set_param_value("BRIGHT_PERCENT", "100");
    str_default_gamma_json_req.set_param_value("PIX_INPUT_BIT_SIZE", "8");
    str_default_gamma_json_req.set_param_value("GRAY_BIT_SIZE", str_url_gray_bit_size);
    str_default_gamma_json_req.set_param_value("GAMA_MAX_VAL", str_max_val);
    str_default_gamma_json_req.set_param_value("GAMA_FACTOR", str_url_gamma_factor);

    $.post("/access_shell", str_default_gamma_json_req.get_json(), function (result, status) {
        if ("success" === status) {
            var obj_param_gamma = new mc_sdk_param();

            obj_param_gamma.set_json(result);
            var str_gamma_tbl = obj_param_gamma.get_param_value("GAMA_TABLE");


            //清除空白 改逗号为英文 去掉重复逗号
            var ary_gamma_tbl = str_gamma_tbl.replace(/，/ig, ",").replace(/\s*/g, "").split(",");

            for (var i = 0; i < ary_gamma_tbl.length; i++) {
                if ("" === ary_gamma_tbl[i]) {
                    str_gamma_tbl.splice(i, 1);
                    i--;
                }
            }

            fun_callback(str_gamma_tbl);
        }
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将未处理的偏移进行处理
 * 参数:
 *    @param {Promise<object>} obj_before_offset  未处理的偏移
 *    @param {Promise<object>} obj_after_offset  已处理过的偏移
 *    @param {Promise<array>} arr_order  当前所有指令
 * 返回：
 *      NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.09.10
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_handle_offset(obj_before_offset, obj_after_offset, arr_order) {
    var ui_len = arr_order.length;

    for (var id = 0; id < ui_len; id++) {
        var str_each_id = arr_order[id];
        var arr_each_id = str_each_id.split(":");
        // 指令前四位
        var str_split_four = arr_each_id[0] + ":" + arr_each_id[1] + ":" + arr_each_id[2] + ":" + arr_each_id[3];
        // 接收卡位置
        var str_recv_idx = arr_each_id[4];

        for (var idx in obj_after_offset) {
            if (Object.hasOwnProperty.call(obj_after_offset, idx)) {
                if (idx === str_split_four) {
                    for (var idx_each_recv = 0; idx_each_recv < obj_after_offset[idx].length; idx_each_recv++) {
                        if (Number(str_recv_idx) === idx_each_recv) {
                            var str_new_x = obj_after_offset[idx][idx_each_recv].X;
                            var str_new_y = obj_after_offset[idx][idx_each_recv].Y;
                            var str_new_offset = "(0:0:" + str_new_x + ":" + str_new_y + ")";

                            obj_before_offset[str_each_id].offset = str_new_offset;
                            break;
                        }
                    }
                    break;
                }
            }
        }
    }
}
